include <BOSL2/std.scad>

stamp_dimensions = [ 2.3*3, 3.2*3, 30*3 ];

mount_length_dimensions = [ 1.5*3, 4*3, 0.8*3 ];
mount_width_dimensions = [ 0.8*3, 1.4*3, 0.6*3 ];
mount_width_offset_from_middle = 8*3;

rounding = 0.2*3;
rounding_length = 0.3*3;
rounding_width = 0.1*3;

tolerance = 0.1;

text_font = "Noto Sans CJK JP:style=Bold";
text_size = 1.25*3;
text_stamp_depth = 1*3;
text_legend_depth = 1*3;

resolution = 32;

module outer_length_mounts()
{
    translate([ stamp_dimensions.x / 2 - (mount_length_dimensions.z - tolerance) / 2, stamp_dimensions.y / 2, 0 ])
        length_mount();
    translate([ -stamp_dimensions.x / 2 + (mount_length_dimensions.z - tolerance) / 2, stamp_dimensions.y / 2, 0 ])
        length_mount();
}

module inner_length_mounts()
{
    translate([ stamp_dimensions.x / 2 - (mount_length_dimensions.z + tolerance) / 2, -stamp_dimensions.y / 2, 0 ])
        length_mount(true);
    translate([ -stamp_dimensions.x / 2 + (mount_length_dimensions.z + tolerance) / 2, -stamp_dimensions.y / 2, 0 ])
        length_mount(true);
}

module outer_width_mounts()
{
    translate([ stamp_dimensions.x / 2, 0, mount_width_offset_from_middle ]) width_mount();
    translate([ stamp_dimensions.x / 2, 0, -mount_width_offset_from_middle ]) width_mount();
}

module inner_width_mounts()
{
    translate([ -stamp_dimensions.x / 2, 0, mount_width_offset_from_middle ]) width_mount(true);
    translate([ -stamp_dimensions.x / 2, 0, -mount_width_offset_from_middle ]) width_mount(true);
}

module stamp(text_character = "0")
{
    difference()
    {
        union()
        {
            cuboid(stamp_dimensions, rounding = rounding, $fn = resolution / 4);
            outer_length_mounts();
            outer_width_mounts();
            translate([ 0, 0, -stamp_dimensions.z / 2 - text_stamp_depth ]) linear_extrude(text_stamp_depth)
                text(text_character, text_size, text_font, halign = "center", valign = "center", $fn = resolution);
        }
        inner_length_mounts();
        inner_width_mounts();
        translate([ 0, 0, stamp_dimensions.z / 2 - text_legend_depth ]) linear_extrude(text_legend_depth)
            text(text_character, text_size, text_font, halign = "center", valign = "center", $fn = resolution);
    }
}

module length_mount(inner = false)
{
    if (inner)
    {
        scale([ 1, mount_length_dimensions.x + tolerance / 2, mount_length_dimensions.y + tolerance / 2 ])
            xcyl(l = mount_length_dimensions.z++ tolerance, r = 1, $fn = resolution, rounding = rounding_length);
    }
    else
    {
        scale([ 1, mount_length_dimensions.x - tolerance / 2, mount_length_dimensions.y - tolerance / 2 ])
            xcyl(l = mount_length_dimensions.z - tolerance, r = 1, $fn = resolution, rounding = rounding_length);
    }
}

module width_mount(inner = false)
{
    if (inner)
    {
        scale([ mount_width_dimensions.x + tolerance / 2, 1, mount_width_dimensions.y + tolerance / 2 ])
            ycyl(l = mount_width_dimensions.z++ tolerance, r = 1, $fn = resolution, rounding = rounding_width);
    }
    else
    {
        scale([ mount_width_dimensions.x - tolerance / 2, 1, mount_width_dimensions.y - tolerance / 2 ])
            ycyl(l = mount_width_dimensions.z - tolerance, r = 1, $fn = resolution, rounding = rounding_width);
    }
}

